<?php
session_start();
require_once '../config/database.php';

// // Check if admin is logged in
// if (!isset($_SESSION['admin_logged_in'])) {
//     header('Location: login.php');
//     exit();
// }

$conn = getConnection();

// Get statistics
$stats = [];
$stats['total_products'] = $conn->query("SELECT COUNT(*) as count FROM products WHERE is_active = 1")->fetch_assoc()['count'];
$stats['total_orders'] = $conn->query("SELECT COUNT(*) as count FROM orders")->fetch_assoc()['count'];
$stats['pending_orders'] = $conn->query("SELECT COUNT(*) as count FROM orders WHERE status = 'pending'")->fetch_assoc()['count'];
$stats['total_revenue'] = $conn->query("SELECT SUM(total_amount) as total FROM orders")->fetch_assoc()['total'] ?? 0;
$stats['low_stock'] = $conn->query("SELECT COUNT(*) as count FROM products WHERE stock_quantity < 10 AND is_active = 1")->fetch_assoc()['count'];

// Get recent orders
$recent_orders = $conn->query("SELECT * FROM orders ORDER BY created_at DESC LIMIT 5");

// Get low stock products
$low_stock_products = $conn->query("SELECT * FROM products WHERE stock_quantity < 10 AND is_active = 1 ORDER BY stock_quantity ASC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Boutique</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(to bottom right, #f8f9fa 0%, #e9ecef 100%);
            min-height: 100vh;
        }

        

        /* Container */
        .container {
            display: flex;
            min-height: calc(100vh - 70px);
        }

        
        /* Main Content */
        .main-content {
            flex: 1;
            padding: 2rem;
        }

        .page-header {
            margin-bottom: 2rem;
        }

        .page-header h1 {
            font-size: 2rem;
            color: #333;
            margin-bottom: 0.5rem;
        }

        .page-header p {
            color: #666;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            transition: transform 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-card.blue {
            border-left: 4px solid #3498db;
        }

        .stat-card.green {
            border-left: 4px solid #2ecc71;
        }

        .stat-card.purple {
            border-left: 4px solid #9b59b6;
        }

        .stat-card.orange {
            border-left: 4px solid #e67e22;
        }

        .stat-info h3 {
            color: #999;
            font-size: 0.9rem;
            font-weight: 500;
            margin-bottom: 0.5rem;
        }

        .stat-info .stat-value {
            font-size: 2rem;
            font-weight: bold;
            color: #333;
        }

        .stat-info .stat-label {
            font-size: 0.85rem;
            color: #666;
            margin-top: 0.5rem;
        }

        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
        }

        .stat-icon.blue { background: linear-gradient(135deg, #3498db, #2980b9); }
        .stat-icon.green { background: linear-gradient(135deg, #2ecc71, #27ae60); }
        .stat-icon.purple { background: linear-gradient(135deg, #9b59b6, #8e44ad); }
        .stat-icon.orange { background: linear-gradient(135deg, #e67e22, #d35400); }

        /* Cards */
        .cards-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 1.5rem;
        }

        .card {
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }

        .card-header {
            font-size: 1.2rem;
            font-weight: bold;
            margin-bottom: 1.5rem;
            color: #333;
        }

        .order-item {
            display: flex;
            justify-content: space-between;
            padding: 1rem;
            border-radius: 10px;
            background: #f8f9fa;
            margin-bottom: 0.75rem;
            transition: background 0.3s;
        }

        .order-item:hover {
            background: #e9ecef;
        }

        .order-id {
            font-weight: 600;
            color: #333;
        }

        .order-customer {
            font-size: 0.9rem;
            color: #666;
        }

        .order-status {
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .status-pending {
            background: #fff3cd;
            color: #856404;
        }

        .status-processing {
            background: #d1ecf1;
            color: #0c5460;
        }

        .status-shipped {
            background: #d4edda;
            color: #155724;
        }

        .status-delivered {
            background: #d4edda;
            color: #155724;
        }

        .low-stock-item {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            background: #fff3cd;
            border-radius: 10px;
            margin-bottom: 0.75rem;
        }

        .low-stock-item img {
            width: 50px;
            height: 50px;
            border-radius: 8px;
            object-fit: cover;
        }

        .low-stock-info {
            flex: 1;
        }

        .low-stock-name {
            font-weight: 600;
            color: #333;
        }

        .low-stock-category {
            font-size: 0.85rem;
            color: #666;
        }

        .stock-count {
            font-size: 1.2rem;
            font-weight: bold;
            color: #e67e22;
        }

        @media (max-width: 768px) {
            .sidebar {
                display: none;
            }

            .stats-grid,
            .cards-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="container">
        <?php include 'sidebar.php'; ?>

        <!-- Main Content -->
        <main class="main-content">
            <div class="page-header">
                <h1>Dashboard Overview</h1>
                <p>Welcome back! Here's what's happening with your store today.</p>
            </div>

            <!-- Stats Cards -->
            <div class="stats-grid">
                <div class="stat-card blue">
                    <div class="stat-info">
                        <h3>Total Products</h3>
                        <div class="stat-value"><?= $stats['total_products'] ?></div>
                        <div class="stat-label"><?= $stats['low_stock'] ?> low stock</div>
                    </div>
                    <div class="stat-icon blue">
                        <i class="fas fa-box"></i>
                    </div>
                </div>

                <div class="stat-card green">
                    <div class="stat-info">
                        <h3>Total Revenue</h3>
                        <div class="stat-value">₹<?= number_format($stats['total_revenue']) ?></div>
                        <div class="stat-label">From <?= $stats['total_orders'] ?> orders</div>
                    </div>
                    <div class="stat-icon green">
                        <i class="fas fa-rupee-sign"></i>
                    </div>
                </div>

                <div class="stat-card purple">
                    <div class="stat-info">
                        <h3>Total Orders</h3>
                        <div class="stat-value"><?= $stats['total_orders'] ?></div>
                        <div class="stat-label">All time</div>
                    </div>
                    <div class="stat-icon purple">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                </div>

                <div class="stat-card orange">
                    <div class="stat-info">
                        <h3>Pending Orders</h3>
                        <div class="stat-value"><?= $stats['pending_orders'] ?></div>
                        <div class="stat-label">Needs attention</div>
                    </div>
                    <div class="stat-icon orange">
                        <i class="fas fa-clock"></i>
                    </div>
                </div>
            </div>

            <!-- Recent Orders and Low Stock -->
            <div class="cards-row">
                <!-- Recent Orders -->
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-shopping-cart"></i> Recent Orders
                    </div>
                    <?php while ($order = $recent_orders->fetch_assoc()): ?>
                        <div class="order-item">
                            <div>
                                <div class="order-id"><?= htmlspecialchars($order['order_id']) ?></div>
                                <div class="order-customer"><?= htmlspecialchars($order['customer_name']) ?></div>
                            </div>
                            <div style="text-align: right;">
                                <div style="font-weight: bold; margin-bottom: 0.25rem;">
                                    ₹<?= number_format($order['total_amount']) ?>
                                </div>
                                <span class="order-status status-<?= $order['status'] ?>">
                                    <?= ucfirst($order['status']) ?>
                                </span>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <a href="orders.php" style="display: block; text-align: center; margin-top: 1rem; color: #667eea; text-decoration: none; font-weight: 500;">
                        View All Orders →
                    </a>
                </div>

                <!-- Low Stock Products -->
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-exclamation-triangle"></i> Low Stock Alert
                    </div>
                    <?php while ($product = $low_stock_products->fetch_assoc()): ?>
                        <div class="low-stock-item">
                            <img src="<?= htmlspecialchars($product['image_url']) ?>" alt="<?= htmlspecialchars($product['name']) ?>">
                            <div class="low-stock-info">
                                <div class="low-stock-name"><?= htmlspecialchars($product['name']) ?></div>
                                <div class="low-stock-category"><?= htmlspecialchars($product['category']) ?></div>
                            </div>
                            <div>
                                <div class="stock-count"><?= $product['stock_quantity'] ?></div>
                                <div style="font-size: 0.8rem; color: #666;">in stock</div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <?php if ($stats['low_stock'] == 0): ?>
                        <p style="text-align: center; color: #2ecc71; padding: 2rem;">
                            <i class="fas fa-check-circle" style="font-size: 2rem; margin-bottom: 0.5rem; display: block;"></i>
                            All products have sufficient stock!
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
<?php $conn->close(); ?>