<?php
session_start();
require_once '../config/database.php';
require_once '../includes/email.php';
$emailService = new EmailService();
$emailService->sendOrderConfirmation($order, $cart);

$conn = getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Process order
    $cart = json_decode($_POST['cart'], true);
    $orderId = 'ORD' . time();
    
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $city = $_POST['city'];
    $state = $_POST['state'];
    $pincode = $_POST['pincode'];
    $payment_method = $_POST['payment_method'];
    $total_amount = $_POST['total_amount'];
    
    // Insert order
    $stmt = $conn->prepare("INSERT INTO orders (order_id, customer_name, customer_email, customer_phone, shipping_address, city, state, pincode, total_amount, payment_method, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')");
    $stmt->bind_param("ssssssssds", $orderId, $name, $email, $phone, $address, $city, $state, $pincode, $total_amount, $payment_method);
    $stmt->execute();
    
    // Insert order items
    foreach ($cart as $item) {
        $stmt = $conn->prepare("INSERT INTO order_items (order_id, product_id, product_name, size, quantity, price) VALUES (?, ?, ?, ?, ?, ?)");
        $size = $item['size'] ?? 'One Size';
        $stmt->bind_param("sissid", $orderId, $item['id'], $item['name'], $size, $item['quantity'], $item['price']);
        $stmt->execute();
        
        // Update stock
        $conn->query("UPDATE products SET stock_quantity = stock_quantity - {$item['quantity']} WHERE product_id = {$item['id']}");
    }
    
    $_SESSION['order_id'] = $orderId;
    header('Location: order-confirmation.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Boutique</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: #f8f9fa;
        }

        .header {
            background: white;
            padding: 1.5rem 2rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .header h1 {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .container {
            max-width: 1200px;
            margin: 2rem auto;
            padding: 0 1rem;
            display: grid;
            grid-template-columns: 1fr 400px;
            gap: 2rem;
        }

        .checkout-form {
            background: white;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }

        .section-title {
            font-size: 1.5rem;
            margin-bottom: 1.5rem;
            color: #333;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #333;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1rem;
        }

        .form-control:focus {
            outline: none;
            border-color: #667eea;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        .payment-option {
            padding: 1rem;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            margin-bottom: 1rem;
            cursor: pointer;
            transition: all 0.3s;
        }

        .payment-option:hover {
            border-color: #667eea;
        }

        .payment-option input[type="radio"] {
            margin-right: 0.5rem;
        }

        .payment-option.selected {
            border-color: #667eea;
            background: #f0f4ff;
        }

        .order-summary {
            background: white;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            position: sticky;
            top: 100px;
            height: fit-content;
        }

        .cart-item {
            display: flex;
            gap: 1rem;
            margin-bottom: 1rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #e0e0e0;
        }

        .cart-item img {
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: 8px;
        }

        .cart-item-details {
            flex: 1;
        }

        .cart-item-name {
            font-weight: 600;
            margin-bottom: 0.25rem;
        }

        .cart-item-price {
            color: #667eea;
            font-weight: bold;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.75rem;
            color: #666;
        }

        .summary-total {
            display: flex;
            justify-content: space-between;
            font-size: 1.5rem;
            font-weight: bold;
            padding-top: 1rem;
            border-top: 2px solid #e0e0e0;
            margin-top: 1rem;
        }

        .btn-place-order {
            width: 100%;
            padding: 1rem;
            background: linear-gradient(135deg, #2ecc71 0%, #27ae60 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: bold;
            cursor: pointer;
            margin-top: 1rem;
        }

        .btn-place-order:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(46, 204, 113, 0.4);
        }

        @media (max-width: 768px) {
            .container {
                grid-template-columns: 1fr;
            }

            .form-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><i class="fas fa-shopping-bag"></i> Boutique Checkout</h1>
    </div>

    <div class="container">
        <div class="checkout-form">
            <form method="POST" id="checkoutForm">
                <input type="hidden" name="cart" id="cartData">
                <input type="hidden" name="total_amount" id="totalAmount">

                <div class="section-title">
                    <i class="fas fa-user"></i> Contact Information
                </div>

                <div class="form-group">
                    <label>Full Name *</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label>Email *</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Phone *</label>
                        <input type="tel" name="phone" class="form-control" pattern="[0-9]{10}" required>
                    </div>
                </div>

                <div class="section-title" style="margin-top: 2rem;">
                    <i class="fas fa-map-marker-alt"></i> Shipping Address
                </div>

                <div class="form-group">
                    <label>Address *</label>
                    <textarea name="address" class="form-control" rows="3" required></textarea>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label>City *</label>
                        <input type="text" name="city" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>State *</label>
                        <input type="text" name="state" class="form-control" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Pincode *</label>
                    <input type="text" name="pincode" class="form-control" pattern="[0-9]{6}" required>
                </div>

                <div class="section-title" style="margin-top: 2rem;">
                    <i class="fas fa-credit-card"></i> Payment Method
                </div>

                <label class="payment-option" onclick="selectPayment(this, 'cod')">
                    <input type="radio" name="payment_method" value="cod" required>
                    <strong>Cash on Delivery</strong>
                    <div style="font-size: 0.9rem; color: #666; margin-top: 0.25rem;">Pay when you receive</div>
                </label>

                <label class="payment-option" onclick="selectPayment(this, 'upi')">
                    <input type="radio" name="payment_method" value="upi" required>
                    <strong>UPI / Online Payment</strong>
                    <div style="font-size: 0.9rem; color: #666; margin-top: 0.25rem;">Pay via UPI, Cards, Net Banking</div>
                </label>

                <button type="submit" class="btn-place-order">
                    <i class="fas fa-check-circle"></i> Place Order
                </button>
            </form>
        </div>

        <div class="order-summary">
            <div class="section-title">
                <i class="fas fa-shopping-cart"></i> Order Summary
            </div>

            <div id="cartItems"></div>

            <div class="summary-row">
                <span>Subtotal:</span>
                <span id="subtotal">₹0</span>
            </div>
            <div class="summary-row">
                <span>Shipping:</span>
                <span id="shipping">₹99</span>
            </div>
            <div class="summary-row" style="color: #2ecc71; font-weight: 600;">
                <span>Discount:</span>
                <span id="discount">₹0</span>
            </div>
            <div class="summary-total">
                <span>Total:</span>
                <span id="total">₹0</span>
            </div>
        </div>
    </div>

    <script>
        const cart = JSON.parse(localStorage.getItem('cart')) || [];
        const FREE_SHIPPING = 5000;
        const SHIPPING_COST = 99;

        function displayCart() {
            const cartItems = document.getElementById('cartItems');
            let html = '';
            let subtotal = 0;

            cart.forEach(item => {
                subtotal += item.price * item.quantity;
                html += `
                    <div class="cart-item">
                        <img src="${item.image}" alt="${item.name}">
                        <div class="cart-item-details">
                            <div class="cart-item-name">${item.name}</div>
                            <div style="font-size: 0.9rem; color: #666;">Qty: ${item.quantity}</div>
                            <div class="cart-item-price">₹${item.price.toLocaleString()}</div>
                        </div>
                    </div>
                `;
            });

            cartItems.innerHTML = html;

            const shipping = subtotal >= FREE_SHIPPING ? 0 : SHIPPING_COST;
            const total = subtotal + shipping;

            document.getElementById('subtotal').textContent = '₹' + subtotal.toLocaleString();
            document.getElementById('shipping').textContent = shipping === 0 ? 'FREE' : '₹' + shipping;
            document.getElementById('total').textContent = '₹' + total.toLocaleString();
            document.getElementById('cartData').value = JSON.stringify(cart);
            document.getElementById('totalAmount').value = total;
        }

        function selectPayment(element, method) {
            document.querySelectorAll('.payment-option').forEach(opt => {
                opt.classList.remove('selected');
            });
            element.classList.add('selected');
        }

        document.getElementById('checkoutForm').addEventListener('submit', function(e) {
            if (cart.length === 0) {
                e.preventDefault();
                alert('Your cart is empty!');
                window.location.href = '../index.php';
            }
        });

        displayCart();
    </script>
</body>
</html>
<?php $conn->close(); ?>