<?php
session_start();
require_once '../config/database.php';

if (!isset($_SESSION['order_id'])) {
    header('Location: ../index.php');
    exit();
}

$conn = getConnection();
$order_id = $_SESSION['order_id'];

// Get order details
$order = $conn->query("SELECT * FROM orders WHERE order_id = '$order_id'")->fetch_assoc();
$items = $conn->query("SELECT * FROM order_items WHERE order_id = '$order_id'");

// Clear cart and order session
unset($_SESSION['order_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmed - Boutique</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }

        .success-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 700px;
            width: 100%;
            overflow: hidden;
        }

        .success-header {
            background: linear-gradient(135deg, #2ecc71 0%, #27ae60 100%);
            color: white;
            padding: 3rem 2rem;
            text-align: center;
        }

        .success-icon {
            width: 80px;
            height: 80px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 2.5rem;
            color: #2ecc71;
        }

        .success-header h1 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        .order-details {
            padding: 2rem;
        }

        .order-id-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            border-radius: 15px;
            text-align: center;
            margin-bottom: 2rem;
        }

        .order-id-box .label {
            font-size: 0.9rem;
            opacity: 0.9;
            margin-bottom: 0.5rem;
        }

        .order-id-box .order-id {
            font-size: 2rem;
            font-weight: bold;
            font-family: monospace;
            letter-spacing: 2px;
        }

        .detail-section {
            margin-bottom: 2rem;
        }

        .detail-section h3 {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: #333;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .detail-box {
            background: #f8f9fa;
            padding: 1.5rem;
            border-radius: 12px;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 0.75rem 0;
            border-bottom: 1px solid #e0e0e0;
        }

        .detail-row:last-child {
            border-bottom: none;
        }

        .order-item {
            display: flex;
            justify-content: space-between;
            padding: 1rem;
            background: white;
            border-radius: 10px;
            margin-bottom: 0.75rem;
            border: 1px solid #e0e0e0;
        }

        .total-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1.5rem;
            border-radius: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 1.3rem;
            font-weight: bold;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            margin-top: 2rem;
        }

        .btn {
            flex: 1;
            padding: 1rem;
            border: none;
            border-radius: 10px;
            font-weight: bold;
            cursor: pointer;
            text-decoration: none;
            text-align: center;
            transition: all 0.3s;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-secondary {
            background: #f8f9fa;
            color: #333;
            border: 2px solid #e0e0e0;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }

        .info-box {
            background: #e3f2fd;
            padding: 1rem;
            border-radius: 10px;
            border-left: 4px solid #2196f3;
            margin-top: 2rem;
        }

        @media (max-width: 768px) {
            .action-buttons {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-header">
            <div class="success-icon">
                <i class="fas fa-check"></i>
            </div>
            <h1>Order Placed Successfully!</h1>
            <p>Thank you for your purchase</p>
        </div>

        <div class="order-details">
            <div class="order-id-box">
                <div class="label">Your Order ID</div>
                <div class="order-id"><?= htmlspecialchars($order['order_id']) ?></div>
            </div>

            <div class="detail-section">
                <h3><i class="fas fa-box"></i> Order Items</h3>
                <div class="detail-box">
                    <?php while ($item = $items->fetch_assoc()): ?>
                        <div class="order-item">
                            <div>
                                <strong><?= htmlspecialchars($item['product_name']) ?></strong><br>
                                <small style="color: #666;">Size: <?= htmlspecialchars($item['size']) ?> | Qty: <?= $item['quantity'] ?></small>
                            </div>
                            <div>
                                <strong>₹<?= number_format($item['price']) ?></strong>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>

            <div class="detail-section">
                <h3><i class="fas fa-map-marker-alt"></i> Delivery Address</h3>
                <div class="detail-box">
                    <div class="detail-row">
                        <span>Name:</span>
                        <strong><?= htmlspecialchars($order['customer_name']) ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Phone:</span>
                        <strong><?= htmlspecialchars($order['customer_phone']) ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Address:</span>
                        <div style="text-align: right;">
                            <strong><?= htmlspecialchars($order['shipping_address']) ?></strong><br>
                            <?= htmlspecialchars($order['city']) ?>, <?= htmlspecialchars($order['state']) ?> - <?= htmlspecialchars($order['pincode']) ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="detail-section">
                <h3><i class="fas fa-credit-card"></i> Payment Information</h3>
                <div class="detail-box">
                    <div class="detail-row">
                        <span>Payment Method:</span>
                        <strong><?= strtoupper($order['payment_method']) ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Payment Status:</span>
                        <strong><?= $order['payment_method'] === 'cod' ? 'Pay on Delivery' : 'Paid' ?></strong>
                    </div>
                </div>
            </div>

            <div class="total-box">
                <span>Total Paid:</span>
                <span>₹<?= number_format($order['total_amount']) ?></span>
            </div>

            <div class="info-box">
                <strong><i class="fas fa-info-circle"></i> What's Next?</strong>
                <ul style="margin-top: 0.5rem; margin-left: 1.5rem;">
                    <li>Order confirmation sent to <?= htmlspecialchars($order['customer_email']) ?></li>
                    <li>Expected delivery: 5-7 business days</li>
                    <li>You'll receive tracking details via email</li>
                </ul>
            </div>

            <div class="action-buttons">
                <a href="../index.php" class="btn btn-primary" onclick="localStorage.removeItem('cart')">
                    <i class="fas fa-shopping-bag"></i> Continue Shopping
                </a>
                <button class="btn btn-secondary" onclick="window.print()">
                    <i class="fas fa-print"></i> Print Receipt
                </button>
            </div>
        </div>
    </div>

    <script>
        // Clear cart from localStorage
        localStorage.removeItem('cart');
    </script>
</body>
</html>
<?php $conn->close(); ?>