<?php
session_start();
require_once '../config/database.php';

$razorpay_payment_id = $_POST['razorpay_payment_id'];
$razorpay_order_id = $_POST['razorpay_order_id'];
$razorpay_signature = $_POST['razorpay_signature'];

// Verify signature
$generated_signature = hash_hmac('sha256', $razorpay_order_id . "|" . $razorpay_payment_id, RAZORPAY_KEY_SECRET);

if ($generated_signature === $razorpay_signature) {
    // Payment verified - save order
    $order_id = $_POST['order_id'];
    $cart = json_decode($_POST['cart'], true);
    $customer_data = json_decode($_POST['customer_data'], true);
    $total_amount = $_POST['total_amount'];
    
    $conn = getConnection();
    
    // Insert order
    $stmt = $conn->prepare("INSERT INTO orders (order_id, customer_name, customer_email, customer_phone, shipping_address, city, state, pincode, total_amount, payment_method, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'razorpay', 'pending')");
    $stmt->bind_param("ssssssssd", $order_id, $customer_data['name'], $customer_data['email'], $customer_data['phone'], $customer_data['address'], $customer_data['city'], $customer_data['state'], $customer_data['pincode'], $total_amount);
    $stmt->execute();
    
    // Insert order items
    foreach ($cart as $item) {
        $stmt = $conn->prepare("INSERT INTO order_items (order_id, product_id, product_name, size, quantity, price) VALUES (?, ?, ?, ?, ?, ?)");
        $size = 'One Size';
        $stmt->bind_param("sissid", $order_id, $item['id'], $item['name'], $size, $item['quantity'], $item['price']);
        $stmt->execute();
    }
    
    $_SESSION['order_id'] = $order_id;
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid signature']);
}
?>