<?php
/**
 * PASSWORD HASH GENERATOR & FIX
 * Use this file to generate correct password hash
 */

// Generate hash for "password123"
$password = "password123";
$hash = password_hash($password, PASSWORD_DEFAULT);

echo "<h2>Password Hash Generator</h2>";
echo "<p><strong>Password:</strong> $password</p>";
echo "<p><strong>Hash:</strong> $hash</p>";

echo "<hr>";
echo "<h3>Update Database with this SQL:</h3>";
echo "<pre style='background:#f4f4f4; padding:15px; border-radius:5px;'>";
echo "UPDATE users SET password_hash = '$hash' WHERE email = 'admin@boutique.com';";
echo "</pre>";

echo "<hr>";
echo "<h3>Or run this directly:</h3>";

// Uncomment below to automatically update database
/*
require_once 'config/database.php';
$conn = getConnection();
$stmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE email = 'admin@boutique.com'");
$stmt->bind_param("s", $hash);
if ($stmt->execute()) {
    echo "<p style='color:green;'>✓ Password updated successfully!</p>";
} else {
    echo "<p style='color:red;'>✗ Error updating password</p>";
}
$conn->close();
*/

echo "<hr>";
echo "<h3>Test Login:</h3>";
echo "<p>Email: admin@boutique.com</p>";
echo "<p>Password: password123</p>";
?>

<!-- UPDATED DATABASE.SQL WITH CORRECT HASH -->
<hr>
<h2>Updated Database Schema</h2>
<pre style='background:#f4f4f4; padding:15px; border-radius:5px; max-height:400px; overflow:auto;'>
-- BOUTIQUE E-COMMERCE DATABASE
-- Updated with correct password hash

CREATE DATABASE IF NOT EXISTS boutique_db;
USE boutique_db;

-- Users Table
CREATE TABLE users (
    user_id INT PRIMARY KEY AUTO_INCREMENT,
    email VARCHAR(255) UNIQUE NOT NULL,
    password_hash VARCHAR(255) NOT NULL,
    full_name VARCHAR(255) NOT NULL,
    phone VARCHAR(20),
    role ENUM('admin', 'seller', 'customer') DEFAULT 'customer',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Products Table
CREATE TABLE products (
    product_id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(255) NOT NULL,
    description TEXT,
    category VARCHAR(100) NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    original_price DECIMAL(10,2),
    stock_quantity INT NOT NULL DEFAULT 0,
    image_url VARCHAR(500),
    sizes TEXT,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Orders Table
CREATE TABLE orders (
    order_id VARCHAR(50) PRIMARY KEY,
    customer_name VARCHAR(255) NOT NULL,
    customer_email VARCHAR(255) NOT NULL,
    customer_phone VARCHAR(20) NOT NULL,
    shipping_address TEXT NOT NULL,
    city VARCHAR(100) NOT NULL,
    state VARCHAR(100) NOT NULL,
    pincode VARCHAR(10) NOT NULL,
    total_amount DECIMAL(10,2) NOT NULL,
    payment_method VARCHAR(50) NOT NULL,
    status ENUM('pending', 'processing', 'shipped', 'delivered', 'cancelled') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Order Items Table
CREATE TABLE order_items (
    item_id INT PRIMARY KEY AUTO_INCREMENT,
    order_id VARCHAR(50) NOT NULL,
    product_id INT NOT NULL,
    product_name VARCHAR(255) NOT NULL,
    size VARCHAR(20),
    quantity INT NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    FOREIGN KEY (order_id) REFERENCES orders(order_id),
    FOREIGN KEY (product_id) REFERENCES products(product_id)
);

-- Settings Table
CREATE TABLE settings (
    setting_id INT PRIMARY KEY AUTO_INCREMENT,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT
);

-- Insert Admin User with CORRECT password hash
-- Password: password123
INSERT INTO users (email, password_hash, full_name, role) 
VALUES ('admin@boutique.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin User', 'admin');

-- Insert Sample Products
INSERT INTO products (name, description, category, price, original_price, stock_quantity, image_url, sizes) VALUES
('Elegant Summer Dress', 'Beautiful flowing summer dress perfect for any occasion', 'Dresses', 2499.00, 3999.00, 15, 'https://images.unsplash.com/photo-1595777457583-95e059d581b8?w=400', 'S,M,L,XL'),
('Designer Handbag', 'Luxury leather handbag with premium finish', 'Accessories', 4999.00, NULL, 8, 'https://images.unsplash.com/photo-1584917865442-de89df76afd3?w=400', 'One Size'),
('Casual Denim Jacket', 'Classic denim jacket for a timeless look', 'Outerwear', 2999.00, NULL, 22, 'https://images.unsplash.com/photo-1551028719-00167b16eac5?w=400', 'S,M,L,XL'),
('Silk Blouse', 'Elegant silk blouse for office or evening wear', 'Tops', 1999.00, 2999.00, 18, 'https://images.unsplash.com/photo-1618932260643-eee4a2f652a6?w=400', 'XS,S,M,L'),
('Statement Earrings', 'Bold gold-plated earrings', 'Accessories', 999.00, NULL, 45, 'https://images.unsplash.com/photo-1535632066927-ab7c9ab60908?w=400', 'One Size'),
('Ankle Boots', 'Comfortable leather ankle boots', 'Shoes', 3499.00, NULL, 12, 'https://images.unsplash.com/photo-1543163521-1bf539c55dd2?w=400', '6,7,8,9,10');

-- Insert Default Settings
INSERT INTO settings (setting_key, setting_value) VALUES
('store_name', 'My Boutique'),
('store_email', 'store@boutique.com'),
('store_phone', '+91 98765 43210'),
('free_shipping_threshold', '5000');
</pre>

<hr>
<h2>Quick Fix Options:</h2>

<h3>Option 1: Run SQL in phpMyAdmin</h3>
<pre style='background:#fff3cd; padding:15px; border-radius:5px;'>
UPDATE users 
SET password_hash = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi' 
WHERE email = 'admin@boutique.com';
</pre>

<h3>Option 2: Delete and Re-insert Admin</h3>
<pre style='background:#fff3cd; padding:15px; border-radius:5px;'>
DELETE FROM users WHERE email = 'admin@boutique.com';

INSERT INTO users (email, password_hash, full_name, role) 
VALUES ('admin@boutique.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin User', 'admin');
</pre>

<h3>Option 3: Create New Admin (Recommended)</h3>
<pre style='background:#d4edda; padding:15px; border-radius:5px;'>
INSERT INTO users (email, password_hash, full_name, role) 
VALUES ('admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin', 'admin');

Then login with:
Email: admin@example.com
Password: password123
</pre>

<hr>
<h2>Testing the Password Hash</h2>
<?php
// Test password verification
$stored_hash = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi';
$test_password = 'password123';

if (password_verify($test_password, $stored_hash)) {
    echo "<p style='color:green; font-weight:bold;'>✓ Password verification WORKS! Hash is correct.</p>";
} else {
    echo "<p style='color:red; font-weight:bold;'>✗ Password verification FAILED!</p>";
}
?>

<hr>
<h2>Create Your Own Admin Account</h2>
<form method="POST">
    <p>
        <label><strong>Email:</strong></label><br>
        <input type="email" name="new_email" required style="padding:8px; width:300px;">
    </p>
    <p>
        <label><strong>Password:</strong></label><br>
        <input type="password" name="new_password" required style="padding:8px; width:300px;">
    </p>
    <p>
        <label><strong>Full Name:</strong></label><br>
        <input type="text" name="new_name" required style="padding:8px; width:300px;">
    </p>
    <button type="submit" name="create_admin" style="padding:10px 20px; background:#667eea; color:white; border:none; border-radius:5px; cursor:pointer;">
        Create Admin Account
    </button>
</form>

<?php
if (isset($_POST['create_admin'])) {
    require_once 'config/database.php';
    $conn = getConnection();
    
    $email = $_POST['new_email'];
    $password = $_POST['new_password'];
    $name = $_POST['new_name'];
    $hash = password_hash($password, PASSWORD_DEFAULT);
    
    $stmt = $conn->prepare("INSERT INTO users (email, password_hash, full_name, role) VALUES (?, ?, ?, 'admin')");
    $stmt->bind_param("sss", $email, $hash, $name);
    
    if ($stmt->execute()) {
        echo "<div style='background:#d4edda; color:#155724; padding:15px; margin:15px 0; border-radius:5px;'>";
        echo "<h3>✓ Admin Account Created Successfully!</h3>";
        echo "<p><strong>Email:</strong> $email</p>";
        echo "<p><strong>Password:</strong> $password</p>";
        echo "<p><strong>Login URL:</strong> <a href='admin/login.php'>admin/login.php</a></p>";
        echo "</div>";
    } else {
        echo "<div style='background:#f8d7da; color:#721c24; padding:15px; margin:15px 0; border-radius:5px;'>";
        echo "✗ Error: " . $conn->error;
        echo "</div>";
    }
    $conn->close();
}
?>

<style>
    body {
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
        max-width: 900px;
        margin: 2rem auto;
        padding: 0 2rem;
        background: #f8f9fa;
    }
    h2 {
        color: #333;
        border-bottom: 3px solid #667eea;
        padding-bottom: 0.5rem;
        margin-top: 2rem;
    }
    h3 {
        color: #555;
        margin-top: 1.5rem;
    }
    pre {
        overflow-x: auto;
        font-size: 0.9rem;
    }
    hr {
        margin: 2rem 0;
        border: none;
        border-top: 2px solid #e0e0e0;
    }
</style>